#!/bin/bash
ENCRYPTION_KEY_FILE="/root/pbs/backup.key"
check_encryption_key() {
    if [ ! -f "$ENCRYPTION_KEY_FILE" ]; then
        echo "Error: Encryption key file not found at $ENCRYPTION_KEY_FILE"
        exit 1
    fi
}

share01_excludes=(
    "docker"
    "restore"
    "syno_app_backups"
)
share02_excludes=(
    "restore"
)
share03_excludes=(
    "restore"
)

backup_share() {
    local share_path="$1"
    local share_name=$(basename "$share_path")
    shift
    local EXCLUDES=("$@")
    echo "Starting backup for $share_path (archive: $share_name)..."
    EXCLUDE_OPTIONS=()
    for exclude_pattern in "${EXCLUDES[@]}"; do
        EXCLUDE_OPTIONS+=(--exclude "$exclude_pattern")
    done
    local backupspec="${share_name}.pxar:$share_path"
    local backup_cmd=(
        proxmox-backup-client backup "$backupspec"
        --keyfile "$ENCRYPTION_KEY_FILE"
        --ns pbs
        "${EXCLUDE_OPTIONS[@]}"
    )
    echo "Executing command: ${backup_cmd[*]}"
    "${backup_cmd[@]}"
    if [ $? -eq 0 ]; then
        echo "Backup of $share_path completed successfully."
    else
        echo "Backup of $share_path FAILED! Check journalctl for details."
        exit 1
    fi
}

echo "Starting daily shares backup."
check_encryption_key
backup_share "/mnt/share01" "${share01_excludes[@]}"
backup_share "/mnt/share02" "${share02_excludes[@]}"
backup_share "/mnt/share03" "${share03_excludes[@]}"
echo "Daily shares backup finished."
